<?php
/**
 * PvP Rankings
 * https://webenginecms.org/
 * 
 * @version 1.1.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2018 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

// namespace
namespace Plugin\PVPRankings;

// plugin root
define('__PATH_PVPRANKINGS_ROOT__', __PATH_PLUGINS__.'pvprankings/');

// plugin root
define('__PVPRANKINGS_HOME__', __BASE_URL__.'rankings/pvp/');

if(file_exists(__PATH_PVPRANKINGS_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) {
	// attempt to load same language as website
	if(!@include_once(__PATH_PVPRANKINGS_ROOT__ . 'languages/'.config('language_default', true).'/language.php')) throw new Exception('Error loading pvp rankings language file.');
} else {
	// load default language file (en)
	if(!@include_once(__PATH_PVPRANKINGS_ROOT__ . 'languages/en/language.php')) throw new Exception('Error loading pvp rankings language file.');
}

// load classes
if(!@include_once(__PATH_PVPRANKINGS_ROOT__ . 'classes/class.pvprankings.php')) throw new Exception(lang('pvprankings_error_1', true));

// rankings menu
addRankingMenuLink(lang('pvprankings_title'), 'pvp', array('igcn'));